<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\OneCSetting */
class OneCSettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'provider' => $this->provider,
            'is_active' => (bool) $this->is_active,
            'endpoint_url' => $this->endpoint_url,
            'username' => $this->username,
            'password' => $this->password,
            'api_key' => $this->api_key,
            'api_secret' => $this->api_secret,
            'webhook_secret' => $this->webhook_secret,
            'exchange_mode' => $this->exchange_mode,
            'auto_sync' => (bool) ($this->auto_sync ?? false),
            'sync_tasks' => (bool) ($this->sync_tasks ?? false),
            'sync_deals' => (bool) ($this->sync_deals ?? false),
            'sync_companies' => (bool) ($this->sync_companies ?? false),
            'sync_contacts' => (bool) ($this->sync_contacts ?? false),
            'sync_products' => (bool) ($this->sync_products ?? false),
            'sync_warehouses' => (bool) ($this->sync_warehouses ?? false),
            'sync_interval_minutes' => (int) ($this->sync_interval_minutes ?? 0),
            'last_sync_at' => $this->last_sync_at,
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}

