<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureApiTokenAbility
{
    /**
     * @param  list<string>  $abilities
     */
    public function handle(Request $request, Closure $next, string ...$abilities): Response
    {
        $user = $request->user();

        if (! $user) {
            abort(401);
        }

        // Browser/session authenticated requests keep current behavior.
        if (! $user->currentAccessToken()) {
            return $next($request);
        }

        foreach ($abilities as $ability) {
            if ($user->tokenCan($ability)) {
                return $next($request);
            }
        }

        abort(403, 'API the key does not have rights for this action.');
    }
}

