<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Throwable;

abstract class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    protected function broadcastToOthers(object $event): void
    {
        try {
            broadcast($event)->toOthers();
        } catch (Throwable $exception) {
            report($exception);
        }
    }
}
