<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">{{ __('Edit warehouse') }}</h2>
            <a href="{{ route('warehouses.show', $warehouse) }}" class="text-sm text-indigo-600 hover:text-indigo-500">{{ __('Open card') }}</a>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-4">
            <form method="POST" action="{{ route('warehouses.update', $warehouse) }}" class="bg-white border border-gray-200 rounded-xl p-6">
                @csrf
                @method('PUT')
                @include('warehouses._form')

                <div class="mt-6 flex items-center justify-end gap-3">
                    <a href="{{ route('warehouses.show', $warehouse) }}" class="px-4 py-2 text-sm text-gray-700">{{ __('Cancel') }}</a>
                    <button type="submit" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">{{ __('Save') }}</button>
                </div>
            </form>

            <form method="POST" action="{{ route('warehouses.destroy', $warehouse) }}" class="text-right" onsubmit="return confirm('{{ __('Delete warehouse?') }}');">
                @csrf
                @method('DELETE')
                <button type="submit" class="text-sm text-red-600 hover:text-red-500">{{ __('Delete warehouse') }}</button>
            </form>
        </div>
    </div>
</x-app-layout>

