<div class="space-y-4 p-5" data-sidepanel-entity="user">
    <section class="rounded-xl border border-slate-200 bg-white p-4">
        <div class="flex items-start gap-4">
            <span class="relative inline-flex h-14 w-14 shrink-0 items-center justify-center rounded-full bg-slate-200 text-sm font-semibold text-slate-700">
                @if ($photoUrl)
                    <span class="h-full w-full overflow-hidden rounded-full">
                        <img src="{{ $photoUrl }}" alt="{{ $member->name }}" class="h-full w-full object-cover" style="{{ $photoStyle }}">
                    </span>
                @else
                    {{ $initials }}
                @endif
                <span class="absolute -bottom-0.5 -right-0.5 h-3 w-3 rounded-full {{ $isOnline ? 'bg-emerald-400' : 'bg-slate-300' }} ring-2 ring-white"></span>
            </span>

            <div class="min-w-0">
                <h3 class="truncate text-base font-semibold text-slate-900">{{ $member->name }}</h3>
                <p class="text-sm text-slate-500">{{ $member->job_title ?: 'Position not specified' }}</p>
                <p class="text-xs text-slate-400">{{ $roleLabel }}</p>
                <p class="mt-1 text-xs text-slate-500">{{ $isOnline ? 'Online' : ($member->last_seen_at?->diffForHumans() ?? 'No activity data') }}</p>
            </div>
        </div>

        <dl class="mt-4 grid grid-cols-1 gap-3 text-sm sm:grid-cols-2">
            <div>
                <dt class="text-slate-500">Email</dt>
                <dd class="text-slate-900">{{ $member->email ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Telephone</dt>
                <dd class="text-slate-900">{{ $member->phone ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Job title</dt>
                <dd class="text-slate-900">{{ $member->job_title ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Supervisor</dt>
                <dd class="text-slate-900">{{ $member->manager?->name ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Company</dt>
                <dd class="text-slate-900">{{ $member->organizationCompany?->name ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Date of birth</dt>
                <dd class="text-slate-900">{{ $member->birth_date?->format('d.m.Y') ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Transactions</dt>
                <dd class="text-slate-900">{{ (int) $member->deals_count }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Tasks</dt>
                <dd class="text-slate-900">{{ (int) $member->assigned_tasks_count }}</dd>
            </div>
        </dl>
    </section>

    <section class="rounded-xl border border-slate-200 bg-white p-4">
        <h4 class="mb-3 text-sm font-semibold text-slate-900">Latest deals</h4>
        <div class="space-y-2">
            @forelse ($recentDeals as $deal)
                <a href="{{ route('deals.show', $deal) }}" class="block rounded-lg border border-slate-200 px-3 py-2 hover:bg-slate-50">
                    <p class="truncate text-sm font-medium text-slate-900">{{ $deal->title }}</p>
                    <p class="text-xs text-slate-500">{{ $deal->stage?->name ?? 'Without stage' }} · ${{ number_format((float) $deal->amount, 0, '.', ' ') }}</p>
                </a>
            @empty
                <p class="text-sm text-slate-500">There are no deals yet.</p>
            @endforelse
        </div>
    </section>

    <section class="rounded-xl border border-slate-200 bg-white p-4">
        <h4 class="mb-3 text-sm font-semibold text-slate-900">Latest tasks</h4>
        <div class="space-y-2">
            @forelse ($recentTasks as $task)
                <a href="{{ route('tasks.show', $task) }}" class="block rounded-lg border border-slate-200 px-3 py-2 hover:bg-slate-50">
                    <p class="truncate text-sm font-medium text-slate-900">#{{ $task->id }} · {{ $task->title }}</p>
                    <p class="text-xs text-slate-500">{{ strtoupper((string) $task->status) }} · {{ $task->due_at?->format('d.m H:i') ?: 'No deadline' }}</p>
                </a>
            @empty
                <p class="text-sm text-slate-500">There are no tasks yet.</p>
            @endforelse
        </div>
    </section>

    <section class="rounded-xl border border-slate-200 bg-white p-4">
        <h4 class="mb-3 text-sm font-semibold text-slate-900">Projects (owner)</h4>
        <div class="space-y-2">
            @forelse ($recentProjects as $project)
                <a href="{{ route('projects.show', $project) }}" class="block rounded-lg border border-slate-200 px-3 py-2 hover:bg-slate-50">
                    <p class="truncate text-sm font-medium text-slate-900">{{ $project->name }}</p>
                    <p class="text-xs text-slate-500">{{ strtoupper((string) $project->status) }} · {{ (int) $project->progress }}%</p>
                </a>
            @empty
                <p class="text-sm text-slate-500">There are no projects yet.</p>
            @endforelse
        </div>
    </section>

    <div class="flex items-center gap-2">
        <a href="{{ route('users.show', $member) }}" data-sidepanel="off" class="inline-flex items-center rounded-md border border-slate-300 px-3 py-2 text-sm font-medium text-slate-700 hover:bg-slate-50">
            Open profile
        </a>
        @if (auth()->id() !== $member->id)
            <a href="{{ route('chat.sidebar', ['member' => $member]) }}" class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-medium text-white hover:bg-indigo-500">
                Open chat
            </a>
        @endif
    </div>
</div>
