@php
    $statusLabels = [
        'todo' => __('To do'),
        'in_progress' => __('In progress'),
        'review' => __('Review'),
        'done' => __('Done'),
    ];

    $priorityLabels = [
        'low' => __('Low'),
        'medium' => __('Medium'),
        'high' => __('High'),
        'urgent' => __('Urgent'),
    ];

@endphp

<div class="space-y-4 p-5" data-sidepanel-entity="task" data-task-live-root>
    <section class="rounded-xl border border-slate-200 bg-white p-4 space-y-4">
        <div class="flex items-start justify-between gap-3">
            <div>
                <h3 class="text-base font-semibold text-slate-900" data-task-live-title data-task-id="{{ $task->id }}">#{{ $task->id }} · {{ $task->title }}</h3>
                <p class="text-xs text-slate-500" data-task-live-meta data-task-id="{{ $task->id }}">{{ $statusLabels[$task->status] ?? $task->status }} · {{ $priorityLabels[$task->priority] ?? $task->priority }}</p>
            </div>
            <span class="inline-flex rounded-full bg-indigo-50 px-2 py-1 text-xs font-semibold text-indigo-700">
                {{ $subtaskStats['progress'] }}%
            </span>
        </div>

        <dl class="grid grid-cols-1 gap-3 text-sm sm:grid-cols-2">
            <div>
                <dt class="text-slate-500">Executor</dt>
                <dd class="text-slate-900">{{ $task->assignee?->name ?? '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Stage Director</dt>
                <dd class="text-slate-900">{{ $task->creator?->name ?? '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Subtasks</dt>
                <dd class="text-slate-900">{{ $subtaskStats['done'] }}/{{ $subtaskStats['total'] }}</dd>
            </div>
        </dl>

        @include('tasks._live-editor', ['liveContext' => 'sidebar'])
    </section>

    <section class="rounded-xl border border-slate-200 bg-white p-4">
        <div class="mb-3 flex items-center justify-between">
            <h4 class="text-sm font-semibold text-slate-900">Subtasks</h4>
            <span class="text-xs text-slate-500">{{ $subtaskStats['done'] }}/{{ $subtaskStats['total'] }}</span>
        </div>

        <div class="space-y-2">
            @forelse ($subtasks->take(8) as $subtask)
                <a href="{{ route('tasks.show', $subtask) }}" class="block rounded-lg border border-slate-200 px-3 py-2 hover:bg-slate-50">
                    <p class="text-sm font-medium text-slate-900">#{{ $subtask->id }} · {{ $subtask->title }}</p>
                    <p class="text-xs text-slate-500">{{ $statusLabels[$subtask->status] ?? $subtask->status }} · {{ $subtask->assignee?->name ?? '—' }}</p>
                </a>
            @empty
                <p class="text-sm text-slate-500">There are no subtasks yet.</p>
            @endforelse
        </div>
    </section>

    <div class="flex items-center gap-2">
        <a href="{{ route('tasks.show', $task) }}" data-sidepanel="off" class="inline-flex items-center rounded-md border border-slate-300 px-3 py-2 text-sm font-medium text-slate-700 hover:bg-slate-50">
            Open card
        </a>
        <a href="{{ route('tasks.create', ['parent_id' => $task->id, 'project_id' => $task->project_id]) }}" data-sidepanel="off" class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-medium text-white hover:bg-indigo-500">
            New subtask
        </a>
    </div>
</div>
