<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('one_c_exchanges', function (Blueprint $table): void {
            $table->id();
            $table->string('external_id')->nullable();
            $table->string('direction', 16)->default('outbound')->index();
            $table->string('entity', 64)->default('deals')->index();
            $table->string('action', 32)->default('upsert')->index();
            $table->string('status', 32)->default('queued')->index();
            $table->json('payload')->nullable();
            $table->json('response')->nullable();
            $table->text('error_message')->nullable();
            $table->timestamp('started_at')->nullable()->index();
            $table->timestamp('finished_at')->nullable()->index();
            $table->foreignId('initiated_by_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->json('meta')->nullable();
            $table->timestamps();

            $table->unique(['direction', 'external_id']);
            $table->index(['entity', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('one_c_exchanges');
    }
};

