<?php

namespace Database\Factories;

use App\Models\User;
use App\Models\Warehouse;
use App\Models\WarehouseAddress;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\WarehouseAddress>
 */
class WarehouseAddressFactory extends Factory
{
    protected $model = WarehouseAddress::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $x = fake()->numberBetween(1, 12);
        $y = fake()->numberBetween(1, 8);

        return [
            'warehouse_id' => Warehouse::factory(),
            'code' => sprintf('A-%02d-%02d', $y, $x),
            'zone' => fake()->optional()->randomElement(['A', 'B', 'C']),
            'aisle' => (string) fake()->numberBetween(1, 20),
            'rack' => (string) fake()->numberBetween(1, 50),
            'shelf' => (string) fake()->numberBetween(1, 10),
            'cell' => (string) fake()->numberBetween(1, 40),
            'x' => $x,
            'y' => $y,
            'color' => fake()->randomElement(['#0EA5E9', '#10B981', '#F97316', '#6366F1']),
            'capacity' => fake()->randomFloat(3, 0, 1000),
            'current_load' => fake()->randomFloat(3, 0, 500),
            'status' => fake()->randomElement(['free', 'reserved', 'blocked']),
            'note' => fake()->optional()->sentence(),
            'created_by' => User::factory(),
        ];
    }
}

