<?php

namespace App\Support;

use App\Models\User;
use App\Support\RightRail\ChatProvider;
use App\Support\RightRail\NotificationProvider;
use Illuminate\Support\Collection;

class RightRailManager
{
    public function __construct(
        private readonly NotificationProvider $notificationProvider,
        private readonly ChatProvider $chatProvider,
    ) {
    }

    /**
     * @return array{notifications: Collection<int, array<string, mixed>>, chats: Collection<int, array<string, mixed>>, unread_count: int, chat_unread_count: int}
     */
    public function data(User $user): array
    {
        $notifications = $this->notificationProvider->notifications($user);
        $chats = $this->chatProvider->chats($user);
        $chatUnreadCount = (int) $chats->sum(fn (array $chat): int => (int) ($chat['unread_count'] ?? 0));

        return [
            'notifications' => $notifications,
            'chats' => $chats,
            'unread_count' => (int) $notifications->count(),
            'chat_unread_count' => $chatUnreadCount,
        ];
    }
}
