<?php

namespace App\Policies;

use App\Models\Pipeline;
use App\Models\User;
use App\Support\AccessControl;

class PipelinePolicy
{
    public function viewAny(User $user): bool
    {
        return AccessControl::allows($user, 'pipelines', 'read');
    }

    public function view(User $user, Pipeline $pipeline): bool
    {
        return AccessControl::allows($user, 'pipelines', 'read');
    }

    public function create(User $user): bool
    {
        return AccessControl::allows($user, 'pipelines', 'create');
    }

    public function update(User $user, Pipeline $pipeline): bool
    {
        return AccessControl::allows($user, 'pipelines', 'update');
    }

    public function delete(User $user, Pipeline $pipeline): bool
    {
        return AccessControl::allows($user, 'pipelines', 'delete');
    }
}
