<?php

namespace App\Policies;

use App\Models\MessengerChannel;
use App\Models\User;
use App\Support\AccessControl;

class MessengerChannelPolicy
{
    public function viewAny(User $user): bool
    {
        return AccessControl::allows($user, 'messengers', 'read');
    }

    public function view(User $user, MessengerChannel $channel): bool
    {
        return AccessControl::allows($user, 'messengers', 'read');
    }

    public function create(User $user): bool
    {
        return AccessControl::allows($user, 'messengers', 'create');
    }

    public function update(User $user, MessengerChannel $channel): bool
    {
        return AccessControl::allows($user, 'messengers', 'update');
    }

    public function delete(User $user, MessengerChannel $channel): bool
    {
        return AccessControl::allows($user, 'messengers', 'delete');
    }
}
