<?php

namespace App\Policies;

use App\Models\Activity;
use App\Models\User;
use App\Support\AccessControl;

class ActivityPolicy
{
    public function viewAny(User $user): bool
    {
        return AccessControl::allows($user, 'activities', 'read');
    }

    public function view(User $user, Activity $activity): bool
    {
        return AccessControl::allows($user, 'activities', 'read');
    }

    public function create(User $user): bool
    {
        return AccessControl::allows($user, 'activities', 'create');
    }

    public function update(User $user, Activity $activity): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'activities', 'update');
        if ($decision !== null) {
            return $decision;
        }

        if (!AccessControl::roleAllows($user, 'activities', 'update')) {
            return false;
        }

        return AccessControl::isElevated($user) || $activity->user_id === $user->id;
    }

    public function delete(User $user, Activity $activity): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'activities', 'delete');
        if ($decision !== null) {
            return $decision;
        }

        if (!AccessControl::roleAllows($user, 'activities', 'delete')) {
            return false;
        }

        return AccessControl::isElevated($user) || $activity->user_id === $user->id;
    }
}
