<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TelephonySetting extends Model
{
    /** @use HasFactory<\Database\Factories\TelephonySettingFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'provider',
        'is_active',
        'api_base_url',
        'api_key',
        'api_secret',
        'account_id',
        'inbound_number',
        'outbound_number',
        'webhook_secret',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
        ];
    }
}
