<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class HrSetting extends Model
{
    /** @use HasFactory<\Database\Factories\HrSettingFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'provider',
        'is_active',
        'api_base_url',
        'api_key',
        'api_secret',
        'webhook_secret',
        'auto_assign_user_id',
        'default_sla_days',
        'allow_employee_requests',
        'require_approval',
        'meta',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
            'auto_assign_user_id' => 'integer',
            'default_sla_days' => 'integer',
            'allow_employee_requests' => 'boolean',
            'require_approval' => 'boolean',
            'meta' => 'array',
        ];
    }

    public function autoAssignUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'auto_assign_user_id');
    }
}

