<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\UpdateCheck */
class UpdateCheckResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'update_setting_id' => (int) ($this->update_setting_id ?? 0),
            'status' => $this->status,
            'endpoint_url' => $this->endpoint_url,
            'http_status' => $this->http_status !== null ? (int) $this->http_status : null,
            'is_update_available' => (bool) $this->is_update_available,
            'remote_version' => $this->remote_version,
            'remote_build' => $this->remote_build,
            'error_message' => $this->error_message,
            'payload' => $this->payload,
            'checked_at' => $this->checked_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}

