<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\HrRequest */
class HrRequestResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'external_id' => $this->external_id,
            'type' => $this->type,
            'status' => $this->status,
            'priority' => $this->priority,
            'title' => $this->title,
            'description' => $this->description,
            'requested_date' => $this->requested_date?->toDateString(),
            'due_date' => $this->due_date?->toDateString(),
            'resolved_date' => $this->resolved_date?->toDateString(),
            'employee_user_id' => $this->employee_user_id,
            'assignee_user_id' => $this->assignee_user_id,
            'creator_user_id' => $this->creator_user_id,
            'employee' => UserResource::make($this->whenLoaded('employee')),
            'assignee' => UserResource::make($this->whenLoaded('assignee')),
            'creator' => UserResource::make($this->whenLoaded('creator')),
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
