<div class="space-y-4 p-5" data-sidepanel-entity="news-create">
    <section class="rounded-xl border border-slate-200 bg-white">
        <div class="border-b border-slate-100 px-4 py-3">
            <h3 class="text-sm font-semibold text-slate-900">{{ __('Create news') }}</h3>
            <p class="mt-1 text-xs text-slate-500">{{ __('Publication in the company feed') }}</p>
        </div>

        <form
            method="POST"
            action="{{ route('news.store') }}"
            enctype="multipart/form-data"
            class="space-y-4 p-4"
            data-sidepanel-submit="1"
            data-sidepanel-success-action="reload"
        >
            @csrf
            <input type="hidden" name="sidepanel" value="1">

            @include('news._form')

            <p class="hidden text-xs font-medium text-emerald-600" data-sidepanel-form-status></p>
            <p class="hidden text-xs font-medium text-red-600" data-sidepanel-form-error></p>

            <div class="flex items-center justify-end gap-2 pt-1">
                <a
                    href="{{ route('news.create') }}"
                    data-sidepanel="off"
                    class="inline-flex items-center rounded-md border border-slate-300 px-3 py-2 text-sm font-medium text-slate-700 hover:bg-slate-50"
                >
                    {{ __('Open page') }}
                </a>
                <button
                    type="submit"
                    data-sidepanel-submit-button
                    class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white transition hover:bg-indigo-500"
                >
                    {{ __('Publish') }}
                </button>
            </div>
        </form>
    </section>
</div>
