@php
    $themes = ($themes ?? collect()) instanceof \Illuminate\Support\Collection
        ? $themes
        : collect($themes ?? []);
    $organizationSetting = $organizationSetting ?? null;
    $activeThemeId = (int) ($organizationSetting?->theme_id ?? 0);
    $defaults = \App\Support\ThemeManager::defaults();
    $paletteDefaults = $defaults['palette'];
    $fontDefaults = $defaults['fonts'];
    $iconDefaults = $defaults['icons'];
@endphp

<section class="space-y-6">
    <header>
        <h2 class="text-lg font-medium text-gray-900">{{ __('Themes') }}</h2>
        <p class="mt-1 text-sm text-gray-600">
            {{ __('Create themes with your own colors, fonts, and icon palette.') }}
        </p>
    </header>

    @if (session('status') === 'theme-created')
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
            {{ __('Theme has been created.') }}
        </div>
    @endif

    @if (session('status') === 'theme-activated')
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
            {{ __('Theme activated.') }}
        </div>
    @endif

    @if (session('status') === 'theme-deleted')
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
            {{ __('Theme deleted.') }}
        </div>
    @endif

    <div class="rounded-lg border border-slate-200 bg-white p-4 shadow-sm">
        <h3 class="text-base font-semibold text-slate-900">{{ __('Create theme') }}</h3>

        <form method="POST" action="{{ route('profile.themes.store') }}" class="mt-4 space-y-5">
            @csrf
            @if ($settingsSection ?? false)
                <input type="hidden" name="_settings_section" value="{{ $settingsSection }}">
            @endif

            <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                <div>
                    <label for="theme_name" class="block text-sm font-medium text-slate-700">{{ __('Theme name') }}</label>
                    <input id="theme_name" name="name" type="text" value="{{ old('name') }}" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                    <x-input-error class="mt-1" :messages="$errors->get('name')" />
                </div>
                <div>
                    <label for="theme_slug" class="block text-sm font-medium text-slate-700">{{ __('Slug') }}</label>
                    <input id="theme_slug" name="slug" type="text" value="{{ old('slug') }}" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="crm-theme">
                    <x-input-error class="mt-1" :messages="$errors->get('slug')" />
                </div>
            </div>

            <div class="grid grid-cols-1 gap-4 lg:grid-cols-2">
                <div class="space-y-3">
                    <h4 class="text-sm font-semibold text-slate-800">{{ __('Colors') }}</h4>
                    <div class="grid grid-cols-1 gap-3 sm:grid-cols-2">
                        @foreach ([
                            'primary' => __('Primary color'),
                            'primary_hover' => __('Primary hover'),
                            'accent' => __('Accent color'),
                            'background' => __('Background'),
                            'surface' => __('Surface'),
                            'surface_alt' => __('Surface alt'),
                            'text' => __('Text'),
                            'text_muted' => __('Muted text'),
                            'border' => __('Border'),
                            'sidebar_bg' => __('Sidebar background'),
                            'sidebar_surface' => __('Sidebar surface'),
                            'sidebar_border' => __('Sidebar border'),
                            'sidebar_text' => __('Sidebar text'),
                            'sidebar_muted' => __('Sidebar muted'),
                            'sidebar_active' => __('Sidebar active'),
                            'right_rail_bg' => __('Right panel background'),
                            'card_bg' => __('Card background'),
                            'input_bg' => __('Input background'),
                        ] as $key => $label)
                            @php
                                $value = old("palette.$key", $paletteDefaults[$key] ?? '#FFFFFF');
                            @endphp
                            <label class="flex items-center justify-between gap-3 rounded-md border border-slate-200 bg-slate-50 px-3 py-2 text-sm text-slate-700">
                                <span>{{ $label }}</span>
                                <input type="color" name="palette[{{ $key }}]" value="{{ $value }}" class="h-8 w-12 cursor-pointer rounded border border-slate-300 bg-white">
                            </label>
                        @endforeach
                    </div>
                </div>

                <div class="space-y-3">
                    <h4 class="text-sm font-semibold text-slate-800">{{ __('Fonts') }}</h4>
                    <div>
                        <label for="font_body" class="block text-sm font-medium text-slate-700">{{ __('Body font') }}</label>
                        <input id="font_body" name="fonts[body]" type="text" value="{{ old('fonts.body', $fontDefaults['body']) }}" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label for="font_heading" class="block text-sm font-medium text-slate-700">{{ __('Heading font') }}</label>
                        <input id="font_heading" name="fonts[heading]" type="text" value="{{ old('fonts.heading', $fontDefaults['heading']) }}" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label for="font_url" class="block text-sm font-medium text-slate-700">{{ __('Font CSS URL') }}</label>
                        <input id="font_url" name="fonts[url]" type="url" value="{{ old('fonts.url', $fontDefaults['url']) }}" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="https://fonts.bunny.net/css?family=...">
                    </div>

                    <h4 class="mt-4 text-sm font-semibold text-slate-800">{{ __('Icons') }}</h4>
                    <div class="grid grid-cols-1 gap-3 sm:grid-cols-2">
                        <label class="flex items-center justify-between gap-3 rounded-md border border-slate-200 bg-slate-50 px-3 py-2 text-sm text-slate-700">
                            <span>{{ __('Icon color') }}</span>
                            <input type="color" name="icons[color]" value="{{ old('icons.color', $iconDefaults['color']) }}" class="h-8 w-12 cursor-pointer rounded border border-slate-300 bg-white">
                        </label>
                        <label class="flex items-center justify-between gap-3 rounded-md border border-slate-200 bg-slate-50 px-3 py-2 text-sm text-slate-700">
                            <span>{{ __('Muted icon color') }}</span>
                            <input type="color" name="icons[muted]" value="{{ old('icons.muted', $iconDefaults['muted']) }}" class="h-8 w-12 cursor-pointer rounded border border-slate-300 bg-white">
                        </label>
                    </div>

                    <div class="mt-4">
                        <label for="theme_css" class="block text-sm font-medium text-slate-700">{{ __('Custom CSS') }}</label>
                        <textarea id="theme_css" name="custom_css" rows="4" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('custom_css') }}</textarea>
                    </div>
                </div>
            </div>

            <div class="flex items-center justify-end">
                <x-primary-button>{{ __('Create theme') }}</x-primary-button>
            </div>
        </form>
    </div>

    <div class="rounded-lg border border-slate-200 bg-white p-4 shadow-sm">
        <h3 class="text-base font-semibold text-slate-900">{{ __('Available themes') }}</h3>

        @if ($themes->isEmpty())
            <p class="mt-3 rounded-md border border-slate-200 bg-slate-50 px-3 py-2 text-sm text-slate-600">
                {{ __('No themes created yet.') }}
            </p>
        @else
            <div class="mt-4 space-y-3">
                @foreach ($themes as $theme)
                    @php
                        $palette = is_array($theme->palette) ? $theme->palette : [];
                        $primary = $palette['primary'] ?? $paletteDefaults['primary'];
                        $accent = $palette['accent'] ?? $paletteDefaults['accent'];
                        $bg = $palette['background'] ?? $paletteDefaults['background'];
                        $isActive = (int) $theme->id === $activeThemeId;
                    @endphp
                    <div class="rounded-lg border border-slate-200 bg-slate-50 px-4 py-3">
                        <div class="flex flex-wrap items-start justify-between gap-4">
                            <div>
                                <p class="text-sm font-semibold text-slate-900">{{ $theme->name }}</p>
                                <p class="text-xs text-slate-500">{{ $theme->slug }}</p>
                                <div class="mt-2 flex items-center gap-2 text-xs text-slate-500">
                                    <span class="inline-flex h-3 w-3 rounded-full" style="background: {{ $primary }}"></span>
                                    <span class="inline-flex h-3 w-3 rounded-full" style="background: {{ $accent }}"></span>
                                    <span class="inline-flex h-3 w-3 rounded-full border border-slate-200" style="background: {{ $bg }}"></span>
                                </div>
                            </div>

                            <div class="flex flex-wrap items-center gap-2">
                                @if ($isActive)
                                    <span class="inline-flex items-center rounded-full bg-emerald-100 px-3 py-1 text-xs font-semibold text-emerald-700">
                                        {{ __('Active') }}
                                    </span>
                                @else
                                    <form method="POST" action="{{ route('profile.themes.activate', ['theme' => $theme->id]) }}">
                                        @csrf
                                        @method('PATCH')
                                        <button type="submit" class="inline-flex items-center rounded-md border border-indigo-200 px-3 py-1.5 text-xs font-semibold text-indigo-700 hover:bg-indigo-50">
                                            {{ __('Activate') }}
                                        </button>
                                    </form>
                                @endif

                                <form method="POST" action="{{ route('profile.themes.destroy', ['theme' => $theme->id]) }}" onsubmit="return confirm('{{ __('Delete theme?') }}')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="inline-flex items-center rounded-md border border-rose-200 px-3 py-1.5 text-xs font-semibold text-rose-700 hover:bg-rose-50">
                                        {{ __('Delete') }}
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</section>
