@php
    $canManageAccess = (bool) ($canManageAccess ?? false);
    $settingsTabs = [
        'profile' => [
            'menu_label' => __('Profile'),
            'view' => 'profile.partials.update-profile-information-form',
        ],
        'localization' => [
            'menu_label' => __('Localization'),
            'view' => 'profile.partials.update-localization-form',
        ],
        'appearance' => [
            'menu_label' => __('Appearance'),
            'view' => 'profile.partials.manage-appearance-form',
        ],
    ];

    if ($canManageAccess) {
        $settingsTabs['company'] = [
            'menu_label' => __('Company'),
            'view' => 'profile.partials.manage-company-settings-form',
        ];

        $settingsTabs['users'] = [
            'menu_label' => __('Users'),
            'view' => 'profile.partials.manage-users-form',
        ];

        $settingsTabs['access'] = [
            'menu_label' => __('Permissions'),
            'view' => 'profile.partials.manage-access-form',
        ];

        $settingsTabs['api'] = [
            'menu_label' => __('API'),
            'view' => 'profile.partials.manage-api-tokens-form',
        ];

        $settingsTabs['updates'] = [
            'menu_label' => __('Updates'),
            'view' => 'profile.partials.manage-updates-form',
        ];

        $settingsTabs['modules'] = [
            'menu_label' => __('Modules'),
            'view' => 'profile.partials.manage-modules-form',
        ];

        $settingsTabs['themes'] = [
            'menu_label' => __('Themes'),
            'view' => 'profile.partials.manage-themes-form',
        ];
    } else {
        $settingsTabs['api'] = [
            'menu_label' => __('API'),
            'view' => 'profile.partials.manage-api-tokens-form',
        ];
    }

    $windowSection = (string) request()->query('section', '');
    $isWindowSection = array_key_exists($windowSection, $settingsTabs);
@endphp

<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Profile') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="w-full px-6 space-y-6" data-sidepanel-scope>
            <nav class="sticky top-0 z-20 rounded-lg border border-slate-200 bg-white/90 p-2 shadow-sm backdrop-blur">
                <div class="flex flex-wrap items-center gap-2">
                    @foreach ($settingsTabs as $key => $tab)
                        @php
                            $isActiveWindowTab = $isWindowSection && $windowSection === $key;
                        @endphp
                        <a
                            href="{{ route('profile.edit', ['section' => $key]) }}"
                            class="inline-flex items-center gap-2 rounded-md border px-3 py-1.5 text-sm font-medium transition
                                {{ $isActiveWindowTab ? 'border-indigo-300 bg-indigo-50 text-indigo-700' : 'border-slate-200 text-slate-700 hover:border-indigo-300 hover:bg-indigo-50 hover:text-indigo-700' }}"
                        >
                            <span>{{ $tab['menu_label'] }}</span>
                        </a>
                    @endforeach
                </div>
            </nav>

            @if ($isWindowSection)
                <div class="bg-white p-4 shadow sm:rounded-lg sm:p-8">
                    <div class="w-full">
                        @include($settingsTabs[$windowSection]['view'], ['settingsSection' => $windowSection])
                    </div>
                </div>
            @else
                <div id="settings-profile" class="scroll-mt-24 bg-white p-4 shadow sm:rounded-lg sm:p-8">
                    <div class="w-full">
                        @include('profile.partials.update-profile-information-form')
                    </div>
                </div>

                <div id="settings-localization" class="scroll-mt-24 bg-white p-4 shadow sm:rounded-lg sm:p-8">
                    <div class="w-full">
                        @include('profile.partials.update-localization-form')
                    </div>
                </div>

                <div id="settings-appearance" class="scroll-mt-24 bg-white p-4 shadow sm:rounded-lg sm:p-8">
                    <div class="w-full">
                        @include('profile.partials.manage-appearance-form')
                    </div>
                </div>

                <div class="bg-white p-4 shadow sm:rounded-lg sm:p-8">
                    <div class="w-full">
                        @include('profile.partials.update-password-form')
                    </div>
                </div>

                <div class="bg-white p-4 shadow sm:rounded-lg sm:p-8">
                    <div class="w-full">
                        @include('profile.partials.update-two-factor-authentication-form')
                    </div>
                </div>

                <div class="bg-white p-4 shadow sm:rounded-lg sm:p-8">
                    <div class="w-full">
                        @include('profile.partials.delete-user-form')
                    </div>
                </div>

                @if ($canManageAccess)
                    <div class="bg-white p-4 shadow sm:rounded-lg sm:p-8">
                        <div class="w-full">
                            @include('profile.partials.manage-company-settings-form')
                        </div>
                    </div>

                    <div class="bg-white p-4 shadow sm:rounded-lg sm:p-8">
                        <div class="w-full">
                            @include('profile.partials.manage-users-form')
                        </div>
                    </div>

                    <div class="bg-white p-4 shadow sm:rounded-lg sm:p-8">
                        <div class="w-full">
                            @include('profile.partials.manage-access-form')
                        </div>
                    </div>

                    <div class="bg-white p-4 shadow sm:rounded-lg sm:p-8">
                        <div class="w-full">
                            @include('profile.partials.manage-updates-form')
                        </div>
                    </div>

                    <div class="bg-white p-4 shadow sm:rounded-lg sm:p-8">
                        <div class="w-full">
                            @include('profile.partials.manage-modules-form')
                        </div>
                    </div>

                    <div class="bg-white p-4 shadow sm:rounded-lg sm:p-8">
                        <div class="w-full">
                            @include('profile.partials.manage-themes-form')
                        </div>
                    </div>
                @endif

            @endif
        </div>
    </div>
</x-app-layout>
