<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">{{ $product->name }}</h2>
                <p class="text-sm text-gray-500">{{ $product->sku ?: '—' }}</p>
            </div>
            <a href="{{ route('products.edit', $product) }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">{{ __('Edit') }}</a>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-6">
            <section class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="bg-white rounded-xl border border-gray-200 p-5 lg:col-span-2">
                    <h3 class="font-semibold text-gray-900">{{ __('Details') }}</h3>
                    <dl class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div>
                            <dt class="text-gray-500">{{ __('Price') }}</dt>
                            <dd class="text-gray-900">{{ number_format((float) $product->price, 2, '.', ' ') }} {{ strtoupper((string) $product->currency) }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">{{ __('In stock') }}</dt>
                            <dd class="text-gray-900">{{ number_format((float) $product->stock, 3, '.', ' ') }} {{ $product->unit }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">{{ __('Company') }}</dt>
                            <dd class="text-gray-900">{{ $product->company?->name ?: '—' }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">{{ __('Responsible') }}</dt>
                            <dd class="text-gray-900">{{ $product->owner?->name ?: '—' }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">{{ __('Status') }}</dt>
                            <dd class="text-gray-900">{{ $product->status === 'archived' ? __('Archived') : __('Active') }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">{{ __('Unit') }}</dt>
                            <dd class="text-gray-900">{{ $product->unit }}</dd>
                        </div>
                    </dl>

                    <div class="mt-4 text-sm">
                        <p class="text-gray-500">{{ __('Description') }}</p>
                        <p class="mt-1 text-gray-900 whitespace-pre-line">{{ $product->description ?: '—' }}</p>
                    </div>
                </div>
            </section>
        </div>
    </div>
</x-app-layout>
