@php
    $product = $product ?? null;
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label for="name" class="block text-sm font-medium text-gray-700">{{ __('Name') }}</label>
        <input id="name" name="name" type="text" required value="{{ old('name', $product?->name) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="sku" class="block text-sm font-medium text-gray-700">{{ __('SKU') }}</label>
        <input id="sku" name="sku" type="text" value="{{ old('sku', $product?->sku) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="price" class="block text-sm font-medium text-gray-700">{{ __('Price') }}</label>
        <input id="price" name="price" type="number" min="0" step="0.01" value="{{ old('price', $product?->price ?? 0) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="currency" class="block text-sm font-medium text-gray-700">{{ __('Currency') }}</label>
        <input id="currency" name="currency" type="text" maxlength="3" required value="{{ old('currency', $product?->currency ?? 'USD') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 uppercase">
    </div>

    <div>
        <label for="stock" class="block text-sm font-medium text-gray-700">{{ __('In stock') }}</label>
        <input id="stock" name="stock" type="number" min="0" step="0.001" value="{{ old('stock', $product?->stock ?? 0) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="unit" class="block text-sm font-medium text-gray-700">{{ __('Unit') }}</label>
        <input id="unit" name="unit" type="text" maxlength="32" required value="{{ old('unit', $product?->unit ?? 'pcs') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="status" class="block text-sm font-medium text-gray-700">{{ __('Status') }}</label>
        <select id="status" name="status" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach ($statusOptions as $value => $label)
                <option value="{{ $value }}" @selected(old('status', $product?->status ?? 'active') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="company_id" class="block text-sm font-medium text-gray-700">{{ __('Company') }}</label>
        <select id="company_id" name="company_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            <option value="">{{ __('Without company') }}</option>
            @foreach ($companies as $company)
                <option value="{{ $company->id }}" @selected((string) old('company_id', $product?->company_id) === (string) $company->id)>{{ $company->name }}</option>
            @endforeach
        </select>
    </div>

    <div class="md:col-span-2">
        <label for="owner_id" class="block text-sm font-medium text-gray-700">{{ __('Responsible') }}</label>
        <x-user-search-select
            id="owner_id"
            name="owner_id"
            :users="$owners"
            :selected="old('owner_id', $product?->owner_id)"
            placeholder="{{ __('Finding the person responsible') }}"
            :empty-label="__('Not assigned')"
        />
    </div>
</div>

<div class="mt-4">
    <label for="description" class="block text-sm font-medium text-gray-700">{{ __('Description') }}</label>
    <textarea id="description" name="description" rows="4" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('description', $product?->description) }}</textarea>
</div>
