<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">{{ __('Create news') }}</h2>
                <p class="text-sm text-gray-500">{{ __('Publication in the company feed') }}</p>
            </div>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6">
            <form method="POST" action="{{ route('news.store') }}" enctype="multipart/form-data" class="space-y-4 rounded-xl border border-gray-200 bg-white p-5">
                @csrf

                @include('news._form')

                <div class="flex items-center justify-end gap-3 pt-2">
                    <a href="{{ route('news.index') }}" class="inline-flex items-center rounded-md border border-gray-300 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50">
                        {{ __('Cancel') }}
                    </a>
                    <button type="submit" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-semibold text-white transition hover:bg-indigo-500">
                        {{ __('Publish') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>
