<div>
    <label for="news-title" class="block text-xs font-semibold uppercase tracking-wide text-slate-600">Heading</label>
    <input
        id="news-title"
        name="title"
        type="text"
        value="{{ old('title') }}"
        maxlength="180"
        required
        class="mt-1 w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
    >
    <x-input-error class="mt-1" :messages="$errors->get('title')" />
    <p class="mt-1 hidden text-xs text-red-600" data-sidepanel-error-for="title"></p>
</div>

<div>
    <label for="news-content" class="block text-xs font-semibold uppercase tracking-wide text-slate-600">News text</label>
    <textarea
        id="news-content"
        name="content"
        rows="6"
        required
        class="mt-1 w-full rounded-md border-slate-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
    >{{ old('content') }}</textarea>
    <x-input-error class="mt-1" :messages="$errors->get('content')" />
    <p class="mt-1 hidden text-xs text-red-600" data-sidepanel-error-for="content"></p>
</div>

<div>
    <label for="news-preview" class="block text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Preview image') }}</label>
    <input
        id="news-preview"
        name="preview"
        type="file"
        accept="image/*"
        class="mt-1 block w-full text-sm text-slate-700 file:mr-3 file:rounded-md file:border-0 file:bg-indigo-50 file:px-3 file:py-2 file:text-sm file:font-medium file:text-indigo-700 hover:file:bg-indigo-100"
    >
    <p class="mt-1 text-xs text-slate-500">{{ __('Optional. Displayed in the news feed.') }}</p>
    <x-input-error class="mt-1" :messages="$errors->get('preview')" />
    <p class="mt-1 hidden text-xs text-red-600" data-sidepanel-error-for="preview"></p>
</div>
