<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Contacts</h2>
            <a href="{{ route('contacts.create') }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">New contact</a>
        </div>
    </x-slot>

    <div class="pb-12" data-sidepanel-scope>
        <div class="w-full px-6 space-y-4">
            <div class="bg-white border border-gray-200 rounded-xl p-4">
                <form method="GET" action="{{ route('contacts.index') }}" class="flex flex-col sm:flex-row gap-3">
                    <input type="text" name="q" value="{{ $search }}" placeholder="Search by name, email, phone" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <button type="submit" class="inline-flex items-center rounded-md bg-gray-800 px-4 py-2 text-sm font-medium text-white hover:bg-gray-700">Find</button>
                </form>
            </div>

            <div class="bg-white border border-gray-200 rounded-xl overflow-hidden">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Contact</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Company</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Responsible</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Transactions</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tasks</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 bg-white">
                        @forelse ($contacts as $contact)
                            @php
                                $contactAvatarUrl = \App\Support\ProfileAvatarManager::url($contact->avatar_path);
                            @endphp
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3">
                                    <div class="flex items-center gap-3">
                                        @if ($contactAvatarUrl)
                                            <img src="{{ $contactAvatarUrl }}" alt="{{ $contact->full_name ?: $contact->first_name }}" class="h-10 w-10 rounded-full border border-gray-200 object-cover">
                                        @else
                                            <div class="inline-flex h-10 w-10 items-center justify-center rounded-full border border-gray-200 bg-gray-100 text-sm font-semibold text-gray-600">
                                                {{ strtoupper(substr((string) ($contact->full_name ?: $contact->first_name ?: 'C'), 0, 1)) }}
                                            </div>
                                        @endif
                                        <div>
                                            <a href="{{ route('contacts.show', $contact) }}" class="font-medium text-gray-900 hover:text-indigo-600">{{ $contact->full_name ?: $contact->first_name }}</a>
                                            <div class="text-xs text-gray-500">{{ $contact->email ?: 'Without email' }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $contact->company?->name ?? '—' }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $contact->owner?->name ?? '—' }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $contact->deals_count }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $contact->tasks_count }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-4 py-8 text-center text-sm text-gray-500">No contacts found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div>
                {{ $contacts->links() }}
            </div>
        </div>
    </div>
</x-app-layout>
