<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mailboxes', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('address')->unique();
            $table->string('local_part');
            $table->string('domain');
            $table->string('status', 32)->default('active')->index();
            $table->boolean('is_primary')->default(false)->index();
            $table->string('password')->nullable();
            $table->unsignedInteger('quota_mb')->default(2048);
            $table->unsignedInteger('used_mb')->default(0);
            $table->string('forward_to')->nullable();
            $table->json('meta')->nullable();
            $table->timestamp('provisioned_at')->nullable()->index();
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();

            $table->unique(['local_part', 'domain']);
            $table->index(['domain', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mailboxes');
    }
};

