<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('warehouses', function (Blueprint $table): void {
            $table->unsignedInteger('map_rows')->default(8)->after('description');
            $table->unsignedInteger('map_columns')->default(12)->after('map_rows');
        });

        Schema::create('warehouse_addresses', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('warehouse_id')->constrained('warehouses')->cascadeOnDelete();
            $table->string('code', 120);
            $table->string('zone', 80)->nullable();
            $table->string('aisle', 80)->nullable();
            $table->string('rack', 80)->nullable();
            $table->string('shelf', 80)->nullable();
            $table->string('cell', 80)->nullable();
            $table->unsignedInteger('x');
            $table->unsignedInteger('y');
            $table->string('color', 20)->default('#0EA5E9');
            $table->decimal('capacity', 14, 3)->default(0);
            $table->decimal('current_load', 14, 3)->default(0);
            $table->string('status', 20)->default('free')->index();
            $table->text('note')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();

            $table->unique(['warehouse_id', 'code']);
            $table->unique(['warehouse_id', 'x', 'y']);
            $table->index(['warehouse_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('warehouse_addresses');

        Schema::table('warehouses', function (Blueprint $table): void {
            $table->dropColumn(['map_rows', 'map_columns']);
        });
    }
};

