<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table): void {
            $table->boolean('sidebar_collapsed')->default(false);
        });

        Schema::create('user_menu_items', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->string('key')->nullable();
            $table->string('label')->nullable();
            $table->string('url')->nullable();
            $table->string('icon');
            $table->unsignedInteger('sort_order')->default(0)->index();
            $table->boolean('is_visible')->default(true);
            $table->boolean('is_custom')->default(false);
            $table->boolean('open_in_new_tab')->default(false);
            $table->timestamps();

            $table->unique(['user_id', 'key']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_menu_items');

        Schema::table('users', function (Blueprint $table): void {
            $table->dropColumn('sidebar_collapsed');
        });
    }
};
