<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tasks', function (Blueprint $table) {
            $table->foreignId('parent_id')
                ->nullable()
                ->after('project_stage_id')
                ->constrained('tasks')
                ->nullOnDelete();
            $table->timestamp('starts_at')->nullable()->after('sort_order')->index();

            $table->index(['parent_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tasks', function (Blueprint $table) {
            $table->dropIndex(['parent_id', 'status']);
            $table->dropColumn('starts_at');
            $table->dropConstrainedForeignId('parent_id');
        });
    }
};
