<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Company>
 */
class CompanyFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->unique()->company(),
            'industry' => fake()->randomElement(['IT', 'Finance', 'Healthcare', 'Retail', 'Manufacturing']),
            'website' => fake()->url(),
            'phone' => fake()->phoneNumber(),
            'email' => fake()->companyEmail(),
            'address' => fake()->address(),
            'owner_id' => User::factory(),
            'source' => fake()->randomElement(['manual', 'website', 'ads', 'referral']),
            'status' => fake()->randomElement(['lead', 'client', 'partner', 'inactive']),
            'notes' => fake()->optional()->paragraph(),
            'avatar_path' => null,
        ];
    }
}
