<?php

namespace Database\Factories;

use App\Models\AccessGroup;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<AccessGroup>
 */
class AccessGroupFactory extends Factory
{
    protected $model = AccessGroup::class;

    /**
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => 'Group '.fake()->unique()->numberBetween(1000, 9999),
            'permissions' => null,
        ];
    }
}
