<?php

namespace App\Policies;

use App\Models\TelephonyCall;
use App\Models\User;
use App\Support\AccessControl;

class TelephonyCallPolicy
{
    public function viewAny(User $user): bool
    {
        return AccessControl::allows($user, 'telephony', 'read');
    }

    public function view(User $user, TelephonyCall $call): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'telephony', 'read');
        if ($decision !== null) {
            return $decision;
        }

        if (! AccessControl::roleAllows($user, 'telephony', 'read')) {
            return false;
        }

        return AccessControl::isElevated($user) || $call->user_id === $user->id;
    }

    public function create(User $user): bool
    {
        return AccessControl::allows($user, 'telephony', 'create');
    }

    public function update(User $user, TelephonyCall $call): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'telephony', 'update');
        if ($decision !== null) {
            return $decision;
        }

        if (! AccessControl::roleAllows($user, 'telephony', 'update')) {
            return false;
        }

        return AccessControl::isElevated($user) || $call->user_id === $user->id;
    }

    public function delete(User $user, TelephonyCall $call): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'telephony', 'delete');
        if ($decision !== null) {
            return $decision;
        }

        if (! AccessControl::roleAllows($user, 'telephony', 'delete')) {
            return false;
        }

        return AccessControl::isElevated($user) || $call->user_id === $user->id;
    }
}
