<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\WarehouseAddress */
class WarehouseAddressResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'warehouse_id' => (int) $this->warehouse_id,
            'code' => $this->code,
            'zone' => $this->zone,
            'aisle' => $this->aisle,
            'rack' => $this->rack,
            'shelf' => $this->shelf,
            'cell' => $this->cell,
            'x' => (int) $this->x,
            'y' => (int) $this->y,
            'color' => $this->color,
            'capacity' => (float) $this->capacity,
            'current_load' => (float) $this->current_load,
            'status' => $this->status,
            'note' => $this->note,
            'creator' => UserResource::make($this->whenLoaded('creator')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}

