<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\OneCExchange */
class OneCExchangeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'external_id' => $this->external_id,
            'direction' => $this->direction,
            'entity' => $this->entity,
            'action' => $this->action,
            'status' => $this->status,
            'payload' => $this->payload,
            'response' => $this->response,
            'error_message' => $this->error_message,
            'started_at' => $this->started_at,
            'finished_at' => $this->finished_at,
            'initiated_by_user_id' => $this->initiated_by_user_id,
            'initiated_by_user' => UserResource::make($this->whenLoaded('initiatedBy')),
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}

