<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\MessengerSetting */
class MessengerSettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'provider' => $this->provider,
            'is_active' => (bool) $this->is_active,
            'api_base_url' => $this->api_base_url,
            'api_key' => $this->api_key,
            'api_secret' => $this->api_secret,
            'account_id' => $this->account_id,
            'allowed_operator_ids' => is_array($this->allowed_operator_ids) ? $this->allowed_operator_ids : [],
            'auto_create_contact' => (bool) ($this->auto_create_contact ?? true),
            'new_contact_action' => $this->new_contact_action ?? 'none',
            'new_contact_action_user_id' => $this->new_contact_action_user_id,
            'webhook_secret' => $this->webhook_secret,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
