<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\MessengerMessage */
class MessengerMessageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'conversation_id' => $this->conversation_id,
            'external_id' => $this->external_id,
            'direction' => $this->direction,
            'body' => $this->body,
            'attachments' => $this->attachments,
            'status' => $this->status,
            'sent_at' => $this->sent_at,
            'user' => UserResource::make($this->whenLoaded('user')),
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
