<?php

namespace App\Http\Resources;

use App\Support\ProfileAvatarManager;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\Company */
class CompanyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'industry' => $this->industry,
            'website' => $this->website,
            'phone' => $this->phone,
            'email' => $this->email,
            'address' => $this->address,
            'source' => $this->source,
            'status' => $this->status,
            'notes' => $this->notes,
            'avatar_url' => ProfileAvatarManager::url($this->avatar_path),
            'owner' => UserResource::make($this->whenLoaded('owner')),
            'contacts_count' => $this->whenCounted('contacts'),
            'deals_count' => $this->whenCounted('deals'),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
