<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <div class="min-w-0">
                <h2 class="truncate text-xl font-semibold leading-tight text-gray-900">{{ $member->name }}</h2>
                <p class="text-sm text-slate-500">{{ $roleLabel }}</p>
            </div>
            @if (auth()->id() !== $member->id)
                <a href="{{ route('chat.sidebar', ['member' => $member]) }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">
                    Open chat
                </a>
            @endif
        </div>
    </x-slot>

    <div class="w-full px-6 pb-12 pt-2" data-sidepanel-scope>
        @include('sidepanel.users.show', [
            'member' => $member,
            'recentDeals' => $recentDeals,
            'recentTasks' => $recentTasks,
            'recentProjects' => $recentProjects,
            'isOnline' => $isOnline,
            'roleLabel' => $roleLabel,
            'photoUrl' => $photoUrl,
            'photoStyle' => $photoStyle,
            'initials' => $initials,
        ])
    </div>
</x-app-layout>
