<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Projects</h2>
            <a href="{{ route('projects.create') }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">New project</a>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-4">
            <section class="bg-white border border-gray-200 rounded-xl p-4">
                <form method="GET" action="{{ route('projects.index') }}" class="grid grid-cols-1 md:grid-cols-4 gap-3">
                    <div>
                        <label for="q" class="block text-xs font-medium text-gray-500 uppercase">Search</label>
                        <input id="q" type="text" name="q" value="{{ $search }}" placeholder="Name, code, company, deal" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>

                    <div>
                        <label for="status" class="block text-xs font-medium text-gray-500 uppercase">Status</label>
                        <select id="status" name="status" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">All</option>
                            @foreach (['planned' => 'Planned', 'active' => 'In work', 'on_hold' => 'Suspended', 'completed' => 'Completed', 'cancelled' => 'Canceled'] as $value => $label)
                                <option value="{{ $value }}" @selected($status === $value)>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label for="manager_id" class="block text-xs font-medium text-gray-500 uppercase">Supervisor</label>
                        <x-user-search-select
                            id="manager_id"
                            name="manager_id"
                            :users="$managers"
                            :selected="$managerId"
                            placeholder="All users"
                            empty-label="All"
                        />
                    </div>

                    <div class="flex items-end gap-2">
                        <button type="submit" class="inline-flex items-center rounded-md bg-gray-800 px-4 py-2 text-sm font-medium text-white hover:bg-gray-700">Apply</button>
                        <a href="{{ route('projects.index') }}" class="inline-flex items-center rounded-md border border-gray-300 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50">Reset</a>
                    </div>
                </form>
            </section>

            <section class="bg-white border border-gray-200 rounded-xl overflow-hidden">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Project</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Deadlines</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Owner/RP</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Progress</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Finance</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tasks</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 bg-white">
                        @forelse ($projects as $project)
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3 align-top">
                                    <a href="{{ route('projects.show', $project) }}" class="font-medium text-gray-900 hover:text-indigo-600">{{ $project->name }}</a>
                                    <div class="text-xs text-gray-500">{{ $project->code }} · {{ $project->company?->name ?? 'Without company' }}</div>
                                    @if ($project->deal)
                                        <div class="text-xs text-indigo-600">Deal: {{ $project->deal->title }}</div>
                                    @endif
                                </td>
                                <td class="px-4 py-3 text-sm text-gray-700 align-top">
                                    {{ $project->starts_at?->format('d.m.Y') ?? '—' }} → {{ $project->due_at?->format('d.m.Y') ?? '—' }}
                                </td>
                                <td class="px-4 py-3 text-sm text-gray-700 align-top">
                                    <div>{{ $project->owner?->name ?? '—' }}</div>
                                    <div class="text-xs text-gray-500">{{ $project->manager?->name ?? '—' }}</div>
                                </td>
                                <td class="px-4 py-3 align-top">
                                    <div class="text-sm text-gray-800 font-medium">{{ $project->progress }}%</div>
                                    <div class="mt-1 h-2 rounded-full bg-gray-100">
                                        <div class="h-2 rounded-full {{ $project->progress >= 80 ? 'bg-emerald-500' : ($project->progress >= 40 ? 'bg-amber-500' : 'bg-indigo-500') }}" style="width: {{ $project->progress }}%;"></div>
                                    </div>
                                </td>
                                <td class="px-4 py-3 text-sm text-gray-700 align-top">
                                    <div>Budget: ${{ number_format((float) $project->budget, 0, '.', ' ') }}</div>
                                    <div class="text-xs text-gray-500">Fact: ${{ number_format((float) $project->spent, 0, '.', ' ') }}</div>
                                </td>
                                <td class="px-4 py-3 text-sm text-gray-700 align-top">
                                    <div>Total: {{ $project->tasks_count }}</div>
                                    <div class="text-xs text-gray-500">Open: {{ $project->open_tasks_count }} · Done: {{ $project->done_tasks_count }}</div>
                                </td>
                                <td class="px-4 py-3 align-top">
                                    @php
                                        $projectStatusLabels = [
                                            'planned' => __('Planned'),
                                            'active' => __('Active'),
                                            'on_hold' => __('On hold'),
                                            'completed' => __('Completed'),
                                            'cancelled' => __('Cancelled'),
                                        ];
                                    @endphp
                                    <span class="inline-flex rounded-full px-2 py-1 text-xs font-medium
                                        {{ $project->status === 'completed' ? 'bg-emerald-100 text-emerald-800' : '' }}
                                        {{ $project->status === 'active' ? 'bg-indigo-100 text-indigo-800' : '' }}
                                        {{ $project->status === 'on_hold' ? 'bg-amber-100 text-amber-800' : '' }}
                                        {{ $project->status === 'planned' ? 'bg-gray-100 text-gray-700' : '' }}
                                        {{ $project->status === 'cancelled' ? 'bg-red-100 text-red-700' : '' }}
                                    ">{{ $projectStatusLabels[$project->status] ?? $project->status }}</span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="px-4 py-8 text-center text-sm text-gray-500">No projects found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </section>

            <div>{{ $projects->links() }}</div>
        </div>
    </div>
</x-app-layout>
