@php
    $accessUsers = ($accessUsers ?? collect()) instanceof \Illuminate\Support\Collection
        ? $accessUsers
        : collect($accessUsers ?? []);
    $accessRoles = is_array($accessRoles ?? null) ? $accessRoles : \App\Support\AccessControl::roles();
    $accessGroups = ($accessGroups ?? collect()) instanceof \Illuminate\Support\Collection
        ? $accessGroups
        : collect($accessGroups ?? []);
    $accessEntities = is_array($accessEntities ?? null) ? $accessEntities : \App\Support\AccessControl::entities();
    $accessActions = is_array($accessActions ?? null) ? $accessActions : \App\Support\AccessControl::actions();
    $currentUser = auth()->user();
    $canManageAccess = (bool) ($canManageAccess ?? false);
    $managers = ($managers ?? collect()) instanceof \Illuminate\Support\Collection
        ? $managers
        : collect($managers ?? []);
    $organizationSetting = $organizationSetting ?? null;
    $organizationChildCompanies = ($organizationChildCompanies ?? collect()) instanceof \Illuminate\Support\Collection
        ? $organizationChildCompanies
        : collect($organizationChildCompanies ?? []);
    $showOrganizationCompanySelector = $organizationChildCompanies->isNotEmpty();
    $newUserRole = (string) old('role', \App\Support\AccessControl::ROLE_USER);
    $newUserPermissions = \App\Support\AccessControl::resolvedPermissions(new \App\Models\User([
        'role' => $newUserRole,
        'permissions' => [],
    ]));
@endphp

<section class="space-y-6">
    <header>
        <h2 class="text-lg font-medium text-gray-900">{{ __('Users') }}</h2>
        <p class="mt-1 text-sm text-gray-600">
            {{ __('List of CRM employees with basic information and quick transition to the user card.') }}
        </p>
    </header>

    @if ($canManageAccess)
        <div class="rounded-lg border border-slate-200 bg-white p-4 shadow-sm">
            <h3 class="text-base font-semibold text-slate-900">{{ __('Create user') }}</h3>
            <p class="mt-1 text-sm text-slate-600">{{ __('Create a new user and assign access rights immediately.') }}</p>

            @if (session('status') === 'user-created')
                <div class="mt-3 rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
                    {{ __('User has been created.') }}
                </div>
            @endif

            <form method="POST" action="{{ route('profile.users.store') }}" class="mt-4 space-y-4">
                @csrf
                @if ($settingsSection ?? false)
                    <input type="hidden" name="_settings_section" value="{{ $settingsSection }}">
                @endif

                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label for="new_user_name" class="block text-sm font-medium text-slate-700">{{ __('Name') }}</label>
                        <input id="new_user_name" name="name" type="text" value="{{ old('name') }}" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                        <x-input-error class="mt-1" :messages="$errors->get('name')" />
                    </div>

                    <div>
                        <label for="new_user_email" class="block text-sm font-medium text-slate-700">{{ __('Email') }}</label>
                        <input id="new_user_email" name="email" type="email" value="{{ old('email') }}" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                        <x-input-error class="mt-1" :messages="$errors->get('email')" />
                    </div>

                    <div>
                        <label for="new_user_password" class="block text-sm font-medium text-slate-700">{{ __('Password') }}</label>
                        <input id="new_user_password" name="password" type="password" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                        <x-input-error class="mt-1" :messages="$errors->get('password')" />
                    </div>

                    <div>
                        <label for="new_user_password_confirmation" class="block text-sm font-medium text-slate-700">{{ __('Confirm Password') }}</label>
                        <input id="new_user_password_confirmation" name="password_confirmation" type="password" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                    </div>
                </div>

                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label for="new_user_phone" class="block text-sm font-medium text-slate-700">{{ __('Telephone') }}</label>
                        <input id="new_user_phone" name="phone" type="text" value="{{ old('phone') }}" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <x-input-error class="mt-1" :messages="$errors->get('phone')" />
                    </div>

                    <div>
                        <label for="new_user_job" class="block text-sm font-medium text-slate-700">{{ __('Job title') }}</label>
                        <input id="new_user_job" name="job_title" type="text" value="{{ old('job_title') }}" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <x-input-error class="mt-1" :messages="$errors->get('job_title')" />
                    </div>

                    <div>
                        <label for="new_user_manager" class="block text-sm font-medium text-slate-700">{{ __('Supervisor') }}</label>
                        <x-user-search-select
                            id="new_user_manager"
                            name="manager_id"
                            :users="$managers"
                            :selected="old('manager_id')"
                            :placeholder="__('Search for a leader')"
                            :empty-label="__('Not selected')"
                        />
                        <x-input-error class="mt-1" :messages="$errors->get('manager_id')" />
                    </div>

                    @if ($showOrganizationCompanySelector)
                        <div>
                            <label for="new_user_company" class="block text-sm font-medium text-slate-700">{{ __('Company') }}</label>
                            <select id="new_user_company" name="organization_company_id" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <option value="">{{ __('Not selected') }}</option>
                                @foreach ($organizationChildCompanies as $organizationCompany)
                                    @php
                                        $parentName = $organizationCompany->parent?->name;
                                        $label = $parentName ? $parentName.' / '.$organizationCompany->name : $organizationCompany->name;
                                    @endphp
                                    <option value="{{ $organizationCompany->id }}" @selected((int) old('organization_company_id') === (int) $organizationCompany->id)>
                                        {{ $label }}
                                    </option>
                                @endforeach
                            </select>
                            <x-input-error class="mt-1" :messages="$errors->get('organization_company_id')" />
                        </div>
                    @endif

                    <div>
                        <label for="new_user_birth_date" class="block text-sm font-medium text-slate-700">{{ __('Date of birth') }}</label>
                        <input id="new_user_birth_date" name="birth_date" type="date" value="{{ old('birth_date') }}" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <x-input-error class="mt-1" :messages="$errors->get('birth_date')" />
                    </div>
                </div>

                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label for="new_user_role" class="block text-sm font-medium text-slate-700">{{ __('User role') }}</label>
                        <select id="new_user_role" name="role" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            @foreach ($accessRoles as $roleKey => $roleLabel)
                                <option value="{{ $roleKey }}" @selected($newUserRole === $roleKey)>
                                    {{ $roleLabel }}
                                </option>
                            @endforeach
                        </select>
                        <x-input-error class="mt-1" :messages="$errors->get('role')" />
                    </div>

                    <div>
                        <label for="new_user_group" class="block text-sm font-medium text-slate-700">{{ __('Group') }}</label>
                        <select id="new_user_group" name="access_group_id" class="mt-1 w-full rounded-md border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">{{ __('No group') }}</option>
                            @foreach ($accessGroups as $group)
                                <option value="{{ $group->id }}" @selected((string) old('access_group_id', '') === (string) $group->id)>
                                    {{ $group->name }}
                                </option>
                            @endforeach
                        </select>
                        <x-input-error class="mt-1" :messages="$errors->get('access_group_id')" />
                    </div>
                </div>

                <div class="overflow-hidden rounded-lg border border-slate-200">
                    <table class="min-w-full divide-y divide-slate-200">
                        <thead class="bg-slate-50">
                            <tr>
                                <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Essence') }}</th>
                                @foreach ($accessActions as $actionKey => $actionLabel)
                                    <th class="px-3 py-2 text-center text-xs font-semibold uppercase tracking-wide text-slate-600">{{ $actionLabel }}</th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-100 bg-white">
                            @foreach ($accessEntities as $entityKey => $entityLabel)
                                <tr>
                                    <td class="px-3 py-2 text-sm font-medium text-slate-800">{{ $entityLabel }}</td>
                                    @foreach ($accessActions as $actionKey => $actionLabel)
                                        <td class="px-3 py-2 text-center">
                                            <input
                                                type="checkbox"
                                                name="permissions[{{ $entityKey }}][{{ $actionKey }}]"
                                                value="1"
                                                class="rounded border-slate-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                                                @checked(
                                                    old("permissions.{$entityKey}.{$actionKey}") !== null
                                                        ? (bool) old("permissions.{$entityKey}.{$actionKey}")
                                                        : (bool) ($newUserPermissions[$entityKey][$actionKey] ?? false)
                                                )
                                            >
                                        </td>
                                    @endforeach
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="flex items-center justify-end">
                    <x-primary-button>{{ __('Create user') }}</x-primary-button>
                </div>
            </form>
        </div>

        <div class="rounded-lg border border-slate-200 bg-white p-4 shadow-sm">
            <h3 class="text-base font-semibold text-slate-900">{{ __('Bulk import') }}</h3>
            <p class="mt-1 text-sm text-slate-600">{{ __('Upload a CSV file to create multiple users with roles, groups, and permissions.') }}</p>

            @if (session('status') === 'users-imported')
                <div class="mt-3 rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
                    {{ __('Users imported successfully.') }}
                </div>
            @endif

            @if ($errors->has('import'))
                <div class="mt-3 rounded-lg border border-rose-200 bg-rose-50 px-4 py-3 text-sm text-rose-800">
                    {{ $errors->first('import') }}
                </div>
            @endif

            @if (session('import_errors'))
                <div class="mt-3 rounded-lg border border-amber-200 bg-amber-50 px-4 py-3 text-sm text-amber-900">
                    <p class="font-semibold">{{ __('Import details') }}</p>
                    <ul class="mt-2 list-disc space-y-1 pl-4">
                        @foreach ((array) session('import_errors') as $detail)
                            <li>{{ $detail }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="mt-4 flex flex-wrap items-center gap-3">
                <a href="{{ route('profile.users.template') }}" class="inline-flex items-center rounded-md border border-slate-300 px-3 py-2 text-sm font-medium text-slate-700 hover:bg-slate-50">
                    {{ __('Download template') }}
                </a>
            </div>

            <form method="POST" action="{{ route('profile.users.import') }}" enctype="multipart/form-data" class="mt-4 space-y-3">
                @csrf
                @if ($settingsSection ?? false)
                    <input type="hidden" name="_settings_section" value="{{ $settingsSection }}">
                @endif

                <div>
                    <label for="import_file" class="block text-sm font-medium text-slate-700">{{ __('CSV file') }}</label>
                    <input id="import_file" name="import_file" type="file" accept=".csv,text/csv" class="mt-1 block w-full text-sm text-slate-700 file:mr-3 file:rounded-md file:border-0 file:bg-indigo-50 file:px-3 file:py-2 file:text-sm file:font-medium file:text-indigo-700 hover:file:bg-indigo-100" required>
                </div>

                <div class="flex items-center justify-end">
                    <x-primary-button>{{ __('Import users') }}</x-primary-button>
                </div>
            </form>
        </div>
    @endif

    @if ($accessUsers->isEmpty())
        <div class="rounded-lg border border-slate-200 bg-slate-50 px-4 py-3 text-sm text-slate-600">
            No users found.
        </div>
    @else
        @php
            $totalUsers = $accessUsers->count();
            $onlineUsers = $accessUsers->filter(fn ($member) => $member->last_seen_at && $member->last_seen_at->gt(now()->subMinutes(5)))->count();
        @endphp

        <div class="grid grid-cols-1 gap-3 sm:grid-cols-3">
            <div class="rounded-lg border border-slate-200 bg-slate-50 px-4 py-3">
                <p class="text-xs uppercase tracking-wide text-slate-500">Total</p>
                <p class="mt-1 text-lg font-semibold text-slate-900">{{ $totalUsers }}</p>
            </div>
            <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3">
                <p class="text-xs uppercase tracking-wide text-emerald-700">Online</p>
                <p class="mt-1 text-lg font-semibold text-emerald-800">{{ $onlineUsers }}</p>
            </div>
            <div class="rounded-lg border border-slate-200 bg-slate-50 px-4 py-3">
                <p class="text-xs uppercase tracking-wide text-slate-500">Offline</p>
                <p class="mt-1 text-lg font-semibold text-slate-900">{{ max(0, $totalUsers - $onlineUsers) }}</p>
            </div>
        </div>

        <div class="overflow-hidden rounded-lg border border-slate-200">
            <table class="min-w-full divide-y divide-slate-200">
                <thead class="bg-slate-50">
                    <tr>
                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">User</th>
                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Contacts</th>
                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Position / Manager</th>
                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Role</th>
                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Status</th>
                        <th class="px-3 py-2 text-right text-xs font-semibold uppercase tracking-wide text-slate-600">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-100 bg-white">
                    @foreach ($accessUsers as $member)
                        @php
                            $isOnline = (bool) ($member->last_seen_at && $member->last_seen_at->gt(now()->subMinutes(5)));
                            $normalizedRole = \App\Support\AccessControl::normalizeRole((string) $member->role);
                        @endphp
                        <tr>
                            <td class="px-3 py-2 align-top">
                                <p class="text-sm font-medium text-slate-900">{{ $member->name }}</p>
                                <p class="text-xs text-slate-500">ID: {{ $member->id }}</p>
                            </td>
                            <td class="px-3 py-2 align-top">
                                <p class="text-sm text-slate-800">{{ $member->email }}</p>
                                <p class="text-xs text-slate-500">{{ $member->phone ?: 'Phone number not specified' }}</p>
                                <p class="text-xs text-slate-500">{{ $member->organizationCompany?->name ? __('Company').": {$member->organizationCompany->name}" : __('Company not selected') }}</p>
                            </td>
                            <td class="px-3 py-2 align-top">
                                <p class="text-sm text-slate-800">{{ $member->job_title ?: '—' }}</p>
                                <p class="text-xs text-slate-500">{{ $member->manager?->name ? "Supervisor: {$member->manager->name}" : 'Without a leader' }}</p>
                            </td>
                            <td class="px-3 py-2 align-top">
                                <span class="inline-flex rounded-full bg-slate-100 px-2 py-1 text-xs font-semibold text-slate-700">
                                    {{ $accessRoles[$normalizedRole] ?? $normalizedRole }}
                                </span>
                            </td>
                            <td class="px-3 py-2 align-top">
                                <span class="inline-flex items-center gap-1 rounded-full px-2 py-1 text-xs font-medium {{ $isOnline ? 'bg-emerald-50 text-emerald-700' : 'bg-slate-100 text-slate-600' }}">
                                    <span class="h-1.5 w-1.5 rounded-full {{ $isOnline ? 'bg-emerald-500' : 'bg-slate-400' }}"></span>
                                    {{ $isOnline ? 'Online' : 'Offline' }}
                                </span>
                            </td>
                            <td class="px-3 py-2 align-top text-right">
                                <div class="inline-flex items-center gap-2">
                                    @if ($currentUser && (int) $currentUser->id !== (int) $member->id)
                                        <form method="POST" action="{{ route('profile.access.impersonate', ['member' => $member]) }}">
                                            @csrf
                                            <button type="submit" class="inline-flex items-center gap-1 text-xs font-medium text-amber-700 hover:text-amber-600" title="Log in as user">
                                                <x-menu-icon name="fa-solid fa-user-secret" class="h-3.5 w-3.5" />
                                                <span>Log in as</span>
                                            </button>
                                        </form>
                                    @endif
                                    <a href="{{ route('users.show', ['member' => $member]) }}" class="text-xs font-medium text-indigo-600 hover:text-indigo-500">
                                        Open
                                    </a>
                                    <a href="{{ route('profile.edit', ['section' => 'access']) }}" class="text-xs font-medium text-slate-600 hover:text-slate-800">
                                        Rights
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</section>
