<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @php
        $themePayload = app(\App\Support\ThemeManager::class)->themeForUser(Auth::user());
        $themeFontUrl = (string) ($themePayload['font_url'] ?? '');
        $themeCssVars = (string) ($themePayload['css_vars'] ?? '');
        $userBackgroundUrl = (string) ($themePayload['background_url'] ?? '');
        $themeCustomCss = (string) ($themePayload['custom_css'] ?? '');
        $rightRailCollapsed = (bool) (Auth::user()?->right_rail_collapsed ?? false);
    @endphp
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'CRM') }}</title>
        <link rel="icon" type="image/png" href="{{ asset('logo_crm25.png') }}">

        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
        <link rel="preload" href="{{ Vite::asset('node_modules/@fortawesome/fontawesome-free/webfonts/fa-solid-900.woff2') }}" as="font" type="font/woff2" crossorigin>
        <link rel="preload" href="{{ Vite::asset('node_modules/@fortawesome/fontawesome-free/webfonts/fa-regular-400.woff2') }}" as="font" type="font/woff2" crossorigin>
        <link rel="preload" href="{{ Vite::asset('node_modules/@fortawesome/fontawesome-free/webfonts/fa-brands-400.woff2') }}" as="font" type="font/woff2" crossorigin>
        @if ($themeFontUrl !== '')
            <link rel="stylesheet" href="{{ $themeFontUrl }}">
        @endif

        @vite(['resources/css/app.css', 'resources/js/app.js'])

        @if ($themeCustomCss !== '')
            <style data-theme-custom>
                {!! $themeCustomCss !!}
            </style>
        @endif
    </head>
    <body
        class="min-w-[1280px] bg-gray-100 font-sans antialiased"
        data-right-rail-collapsed="{{ $rightRailCollapsed ? '1' : '0' }}"
        data-theme="custom"
        data-user-bg="{{ $userBackgroundUrl !== '' ? '1' : '0' }}"
        style="{{ $themeCssVars }}{{ $userBackgroundUrl !== '' ? '; --user-bg-image: url(&quot;' . $userBackgroundUrl . '&quot;);' : '' }}"
    >
        <div class="min-h-screen bg-gray-100 flex" data-right-rail-root>
            @include('layouts.navigation')

            <div class="flex-1 min-w-0 {{ $rightRailCollapsed ? 'pr-0' : 'pr-[20rem]' }} transition-[padding] duration-200" data-right-rail-content>
                @isset($header)
                    <header class="bg-white border-b border-gray-200">
                        <div class="w-full px-6 py-5">
                            {{ $header }}
                        </div>
                    </header>
                @endisset

                <main>
                    <div class="w-full px-6 py-6">
                        @include('partials.flash')
                    </div>

                    {{ $slot }}
                </main>
            </div>
        </div>

        @include('layouts.right-rail')
        @include('layouts.sidepanel')
    </body>
</html>
