<x-app-layout>
    @php
        $contactAvatarUrl = \App\Support\ProfileAvatarManager::url($contact->avatar_path);
    @endphp
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <div class="flex items-center gap-3">
                @if ($contactAvatarUrl)
                    <img src="{{ $contactAvatarUrl }}" alt="{{ $contact->full_name ?: $contact->first_name }}" class="h-12 w-12 rounded-full border border-gray-200 object-cover">
                @else
                    <div class="inline-flex h-12 w-12 items-center justify-center rounded-full border border-gray-200 bg-gray-100 text-base font-semibold text-gray-600">
                        {{ strtoupper(substr((string) ($contact->full_name ?: $contact->first_name ?: 'C'), 0, 1)) }}
                    </div>
                @endif
                <div>
                    <h2 class="font-semibold text-xl text-gray-800 leading-tight">{{ $contact->full_name ?: $contact->first_name }}</h2>
                    <p class="text-sm text-gray-500">{{ $contact->title ?: 'Position not specified' }}</p>
                </div>
            </div>
            <a href="{{ route('contacts.edit', $contact) }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">Edit</a>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-6">
            <section class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="bg-white rounded-xl border border-gray-200 p-5 lg:col-span-2">
                    <h3 class="font-semibold text-gray-900">Profile</h3>
                    <dl class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div>
                            <dt class="text-gray-500">Email</dt>
                            <dd class="text-gray-900">{{ $contact->email ?: '—' }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">Telephone</dt>
                            <dd class="text-gray-900">{{ $contact->phone ?: '—' }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">Company</dt>
                            <dd class="text-gray-900">
                                @if ($contact->company)
                                    <a href="{{ route('companies.show', $contact->company) }}" class="text-indigo-600 hover:text-indigo-500">{{ $contact->company->name }}</a>
                                @else
                                    —
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">Responsible</dt>
                            <dd class="text-gray-900">{{ $contact->owner?->name ?: '—' }}</dd>
                        </div>
                    </dl>

                    <div class="mt-4 text-sm">
                        <p class="text-gray-500">Notes</p>
                        <p class="mt-1 text-gray-900 whitespace-pre-line">{{ $contact->notes ?: 'No notes' }}</p>
                    </div>
                </div>

                <div class="bg-white rounded-xl border border-gray-200 p-5">
                    <h3 class="font-semibold text-gray-900">Quick Actions</h3>
                    <div class="mt-3 space-y-2 text-sm">
                        <a href="{{ route('deals.create', ['contact_id' => $contact->id, 'company_id' => $contact->company_id]) }}" class="block rounded-md border border-gray-200 px-3 py-2 hover:bg-gray-50">Add a deal</a>
                        <a href="{{ route('tasks.create', ['contact_id' => $contact->id, 'company_id' => $contact->company_id]) }}" class="block rounded-md border border-gray-200 px-3 py-2 hover:bg-gray-50">Create a task</a>
                        <a href="{{ route('activities.create', ['contact_id' => $contact->id, 'company_id' => $contact->company_id]) }}" class="block rounded-md border border-gray-200 px-3 py-2 hover:bg-gray-50">Activity log</a>
                    </div>
                </div>
            </section>

            <section class="grid grid-cols-1 xl:grid-cols-2 gap-6">
                <div class="bg-white rounded-xl border border-gray-200 p-5">
                    <h3 class="font-semibold text-gray-900">Transactions ({{ $contact->deals->count() }})</h3>
                    <div class="mt-3 space-y-2">
                        @forelse ($contact->deals as $deal)
                            <a href="{{ route('deals.show', $deal) }}" class="block rounded-md border border-gray-100 px-3 py-2 hover:bg-gray-50">
                                <div class="flex items-center justify-between gap-3">
                                    <p class="text-sm font-medium text-gray-900">{{ $deal->title }}</p>
                                    <span class="text-sm text-gray-700">${{ number_format((float) $deal->amount, 0, '.', ' ') }}</span>
                                </div>
                                <p class="text-xs text-gray-500">{{ $deal->stage?->name ?? '—' }}</p>
                            </a>
                        @empty
                            <p class="text-sm text-gray-500">There are no deals yet.</p>
                        @endforelse
                    </div>
                </div>

                <div class="bg-white rounded-xl border border-gray-200 p-5">
                    <h3 class="font-semibold text-gray-900">Tasks ({{ $contact->tasks->count() }})</h3>
                    <div class="mt-3 space-y-2">
                        @forelse ($contact->tasks as $task)
                            <a href="{{ route('tasks.show', $task) }}" class="block rounded-md border border-gray-100 px-3 py-2 hover:bg-gray-50">
                                <p class="text-sm font-medium text-gray-900">{{ $task->title }}</p>
                                <p class="text-xs text-gray-500">{{ strtoupper($task->status) }} · {{ $task->due_at?->format('d.m H:i') ?: 'No deadline' }}</p>
                            </a>
                        @empty
                            <p class="text-sm text-gray-500">There are no tasks yet.</p>
                        @endforelse
                    </div>
                </div>
            </section>
        </div>
    </div>
</x-app-layout>
