@php
    $company = $company ?? null;
    $avatarPath = (string) old('avatar_path_existing', $company?->avatar_path ?? '');
    $avatarRemoved = (bool) old('remove_avatar', false);
    $avatarUrl = (! $avatarRemoved && $avatarPath !== '')
        ? \App\Support\ProfileAvatarManager::url($avatarPath)
        : null;
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
        <input id="name" name="name" type="text" required value="{{ old('name', $company?->name) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="industry" class="block text-sm font-medium text-gray-700">Industry</label>
        <input id="industry" name="industry" type="text" value="{{ old('industry', $company?->industry) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="website" class="block text-sm font-medium text-gray-700">Website</label>
        <input id="website" name="website" type="url" value="{{ old('website', $company?->website) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="phone" class="block text-sm font-medium text-gray-700">Telephone</label>
        <input id="phone" name="phone" type="text" value="{{ old('phone', $company?->phone) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="email" class="block text-sm font-medium text-gray-700">Email</label>
        <input id="email" name="email" type="email" value="{{ old('email', $company?->email) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="owner_id" class="block text-sm font-medium text-gray-700">Responsible</label>
        <x-user-search-select
            id="owner_id"
            name="owner_id"
            :users="$owners"
            :selected="old('owner_id', $company?->owner_id)"
            placeholder="Finding the person responsible"
            empty-label="Not assigned"
        />
    </div>

    <div>
        <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
        <select id="status" name="status" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach (['lead' => 'Lead', 'client' => 'Client', 'partner' => 'Partner', 'inactive' => 'Inactive'] as $value => $label)
                <option value="{{ $value }}" @selected(old('status', $company?->status ?? 'lead') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="source" class="block text-sm font-medium text-gray-700">Source</label>
        <input id="source" name="source" type="text" value="{{ old('source', $company?->source ?? 'manual') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>
</div>

<div class="mt-4">
    <label for="address" class="block text-sm font-medium text-gray-700">{{ __('Address') }}</label>
    <textarea id="address" name="address" rows="2" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('address', $company?->address) }}</textarea>
</div>

<div class="mt-4 rounded-lg border border-gray-200 p-4">
    <p class="text-sm font-medium text-gray-700">{{ __('Avatar') }}</p>
    <div class="mt-3 grid grid-cols-1 gap-4 md:grid-cols-[auto_minmax(0,1fr)]">
        <div class="flex items-center justify-center">
            @if ($avatarUrl)
                <img src="{{ $avatarUrl }}" alt="{{ $company?->name ?? __('Avatar') }}" class="h-16 w-16 rounded-full border border-gray-200 object-cover">
            @else
                <div class="inline-flex h-16 w-16 items-center justify-center rounded-full border border-gray-200 bg-gray-100 text-lg font-semibold text-gray-600">
                    {{ strtoupper(substr((string) old('name', $company?->name ?? 'C'), 0, 1)) }}
                </div>
            @endif
        </div>
        <div>
            <input type="hidden" name="avatar_path_existing" value="{{ $avatarPath }}">
            <label for="company-avatar" class="block text-xs font-medium uppercase tracking-wide text-gray-500">{{ __('Upload image') }}</label>
            <input id="company-avatar" name="avatar" type="file" accept="image/*" class="mt-1 block w-full text-sm text-slate-700 file:mr-3 file:rounded-md file:border-0 file:bg-indigo-50 file:px-3 file:py-2 file:text-sm file:font-medium file:text-indigo-700 hover:file:bg-indigo-100">
            <x-input-error class="mt-1" :messages="$errors->get('avatar')" />
            @if ($avatarUrl)
                <label class="mt-3 inline-flex items-center gap-2 text-sm text-gray-700">
                    <input type="checkbox" name="remove_avatar" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked((bool) old('remove_avatar'))>
                    <span>{{ __('Delete current photo') }}</span>
                </label>
            @endif
        </div>
    </div>
</div>

<div class="mt-4">
    <label for="notes" class="block text-sm font-medium text-gray-700">Notes</label>
    <textarea id="notes" name="notes" rows="4" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('notes', $company?->notes) }}</textarea>
</div>
