<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('hr_settings', function (Blueprint $table): void {
            $table->id();
            $table->string('provider')->default('internal');
            $table->boolean('is_active')->default(true);
            $table->string('api_base_url')->nullable();
            $table->string('api_key')->nullable();
            $table->string('api_secret')->nullable();
            $table->string('webhook_secret')->nullable();
            $table->foreignId('auto_assign_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->unsignedInteger('default_sla_days')->default(3);
            $table->boolean('allow_employee_requests')->default(true);
            $table->boolean('require_approval')->default(true);
            $table->json('meta')->nullable();
            $table->timestamps();

            $table->index('provider');
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hr_settings');
    }
};

