<?php

namespace Database\Factories;

use App\Models\Company;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Contact>
 */
class ContactFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'first_name' => fake()->firstName(),
            'last_name' => fake()->lastName(),
            'title' => fake()->jobTitle(),
            'email' => fake()->safeEmail(),
            'phone' => fake()->phoneNumber(),
            'company_id' => Company::factory(),
            'owner_id' => User::factory(),
            'source' => fake()->randomElement(['manual', 'website', 'ads', 'referral']),
            'last_contacted_at' => fake()->optional()->dateTimeBetween('-30 days', 'now'),
            'notes' => fake()->optional()->paragraph(),
            'avatar_path' => null,
        ];
    }
}
