<?php

namespace App\Policies;

use App\Models\Deal;
use App\Models\User;
use App\Support\AccessControl;

class DealPolicy
{
    public function viewAny(User $user): bool
    {
        return AccessControl::allows($user, 'deals', 'read');
    }

    public function view(User $user, Deal $deal): bool
    {
        return AccessControl::allows($user, 'deals', 'read');
    }

    public function create(User $user): bool
    {
        return AccessControl::allows($user, 'deals', 'create');
    }

    public function update(User $user, Deal $deal): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'deals', 'update');
        if ($decision !== null) {
            return $decision;
        }

        if (!AccessControl::roleAllows($user, 'deals', 'update')) {
            return false;
        }

        return AccessControl::isElevated($user)
            || $deal->owner_id === $user->id
            || $deal->owner_id === null;
    }

    public function delete(User $user, Deal $deal): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'deals', 'delete');
        if ($decision !== null) {
            return $decision;
        }

        if (!AccessControl::roleAllows($user, 'deals', 'delete')) {
            return false;
        }

        return AccessControl::isElevated($user);
    }
}
