<?php

namespace App\Http\Resources;

use App\Support\ProfileAvatarManager;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\User */
class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'job_title' => $this->job_title,
            'manager_id' => $this->manager_id,
            'manager_name' => $this->manager?->name,
            'birth_date' => $this->birth_date?->toDateString(),
            'role' => $this->role,
            'profile_photo_url' => ProfileAvatarManager::url($this->profile_photo_path),
            'profile_photo_focus_x' => ProfileAvatarManager::normalizeFocusX($this->profile_photo_focus_x),
            'profile_photo_focus_y' => ProfileAvatarManager::normalizeFocusY($this->profile_photo_focus_y),
            'profile_photo_zoom' => ProfileAvatarManager::normalizeZoom($this->profile_photo_zoom),
        ];
    }
}
