<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\UpdateInstallation */
class UpdateInstallationResource extends JsonResource
{
    /**
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'update_setting_id' => (int) ($this->update_setting_id ?? 0),
            'update_check_id' => $this->update_check_id !== null ? (int) $this->update_check_id : null,
            'actor_id' => $this->actor_id !== null ? (int) $this->actor_id : null,
            'status' => $this->status,
            'target_version' => $this->target_version,
            'target_build' => $this->target_build,
            'package_url' => $this->package_url,
            'package_name' => $this->package_name,
            'package_path' => $this->package_path,
            'backup_path' => $this->backup_path,
            'checksum_sha256' => $this->checksum_sha256,
            'message' => $this->message,
            'events' => $this->events,
            'started_at' => $this->started_at,
            'finished_at' => $this->finished_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
