<?php

namespace App\Http\Resources;

use App\Support\ProfileAvatarManager;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\Contact */
class ContactResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'full_name' => $this->full_name,
            'title' => $this->title,
            'email' => $this->email,
            'phone' => $this->phone,
            'source' => $this->source,
            'last_contacted_at' => $this->last_contacted_at,
            'notes' => $this->notes,
            'avatar_url' => ProfileAvatarManager::url($this->avatar_path),
            'company' => CompanyResource::make($this->whenLoaded('company')),
            'owner' => UserResource::make($this->whenLoaded('owner')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
