<?php

declare(strict_types=1);

$rootPath = __DIR__;

require $rootPath.'/src/bootstrap.php';
require $rootPath.'/src/UpdateReleaseRepository.php';

$config = update_center_bootstrap($rootPath);
$repository = new UpdateReleaseRepository($config['pdo'], $config['base_url']);

$options = getopt('', [
    'product::',
    'version:',
    'build::',
    'channel::',
    'notes::',
    'package:',
    'active::',
]);

$package = trim((string) ($options['package'] ?? ''));
$version = trim((string) ($options['version'] ?? ''));
$product = trim((string) ($options['product'] ?? $config['default_product']));
$build = trim((string) ($options['build'] ?? ''));
$channel = trim((string) ($options['channel'] ?? 'stable'));
$notes = trim((string) ($options['notes'] ?? ''));
$active = ! isset($options['active']) || in_array((string) $options['active'], ['1', 'true', 'yes'], true);

if ($package === '' || ! is_file($package)) {
    fwrite(STDERR, "Package file not found.\n");
    exit(1);
}

if ($version === '') {
    fwrite(STDERR, "Version is required.\n");
    exit(1);
}

if (! in_array($channel, ['stable', 'beta', 'nightly'], true)) {
    fwrite(STDERR, "Invalid channel.\n");
    exit(1);
}

$targetFileName = gmdate('YmdHis').'-'.update_center_slug($version).'-'.basename($package);
$targetPath = rtrim((string) $config['package_path'], '/').'/'.$targetFileName;

if (! copy($package, $targetPath)) {
    fwrite(STDERR, "Failed to copy package.\n");
    exit(1);
}

$releaseId = $repository->create([
    'product' => $product !== '' ? $product : $config['default_product'],
    'version' => $version,
    'build' => $build,
    'channel' => $channel,
    'notes' => $notes,
    'file_name' => $targetFileName,
    'original_file_name' => basename($package),
    'file_path' => $targetPath,
    'file_size' => filesize($targetPath) ?: 0,
    'checksum_sha256' => hash_file('sha256', $targetPath),
    'is_active' => $active,
    'published_at' => gmdate('c'),
]);

fwrite(STDOUT, "Release #{$releaseId} created.\n");
