# CRM25 Update Center

Standalone lightweight update server for CRM25.

## Features

- release upload via `/admin`
- Basic Auth protected admin panel
- SQLite storage, no external dependencies
- public JSON feed endpoints compatible with CRM25:
  - `/api/v1/crm25/updates`
  - `/api/v1/updates`
  - `/api/updates`
  - `/updates.json`
- ZIP package downloads via `/downloads/{id}/{file}`

## Local launch

```bash
cd update-center/public
php -S 127.0.0.1:8090
```

Then open:

- home: `http://127.0.0.1:8090/`
- admin: `http://127.0.0.1:8090/admin`

Default admin credentials:

- user: `crm25`
- password: `change-me-now`

Override them by copying `config.example.php` to `config.local.php` and editing values.

## Deploy

Recommended Nginx root:

- project root: `/var/www/update.crm25.webnet.kz`
- public root: `/var/www/update.crm25.webnet.kz/public`

Use the sample server block from `deploy/nginx.update.crm25.webnet.kz.conf`.

## Feed example

```bash
curl "https://update.crm25.webnet.kz/api/v1/crm25/updates?product=crm25&channel=stable&version=25.0.0"
```

Example response:

```json
{
  "product": "crm25",
  "channel": "stable",
  "version": "25.0.1",
  "latest_version": "25.0.1",
  "build": "250001",
  "latest_build": "250001",
  "notes": "Bug fixes and UI improvements.",
  "published_at": "2026-02-28T21:00:00+00:00",
  "download_url": "https://update.crm25.webnet.kz/downloads/1/crm25-25-0-1.zip",
  "checksum_sha256": "sha256-here",
  "file_name": "crm25-25.0.1.zip",
  "file_size": 12345678,
  "is_update_available": true
}
```
